// // // // // // // // // // // // // // // // // // // //
//	
//	Basic Agent
//	
//	created Apr/12/98 by Andreas Warnke
//	last mod Apr/14/98 by Andreas Warnke
//	
//	This file contains only the main function,
//	which initiates, runs and kills the BApplication.
//	
//	Every Object is declared in its own .h file
//	and defined in its own .cc file.
//



// // // // // // // // // // // // // // // // // // // //
//	
//	Naming conventions
//
//	local variables, that are placed on the stack, begin 
//	with 's'; enumerated constants begin with 'e'.
//	Parameters begin with 'in', 'io' or 'out'.
//	



// // // // // // // // // // // // // // // // // // // //
//	
//	include
//

#include <Be.h>
#include "GlobalVariables.h"
#include "BasicWindow.h"
#include "SimpleReflexAgent.h"



// // // // // // // // // // // // // // // // // // // //
//	
//	main
//

int main ()
{
	//	Create the BApplication object:
	BApplication * sAgentApp = new BApplication ( eBasicAgentMIME );		
	if ( sAgentApp == NULL )
		//	There's not enough memory.
		//	terminate application:
		return B_ERROR;
	
	//	The sAgentApp object was created successfully.

	//	Create the Simple Reflex Agent:
	TheSimpleReflexAgent = new SimpleReflexAgent ();
	if ( TheSimpleReflexAgent != NULL )
		//	Agent exists.
		//	Run the Agent:
		TheSimpleReflexAgent -> Run ();
	
	//	Open the Status-Window and Run the Application:
	TheStatusWindow = new BasicWindow ();	
	if ( TheStatusWindow != NULL )
		//	Window exists.
		//	Run the Application:
		sAgentApp -> Run ();
		
	if ( TheSimpleReflexAgent != NULL )
	{
		//	Agent exists.
		//	delete the Agent:
		TheSimpleReflexAgent -> Quit ();
		TheSimpleReflexAgent = NULL;
	};
		
	//	kill the app and free the memory:
	delete sAgentApp;
	return B_OK;
};



//	
//	The End.
//	
// // // // // // // // // // // // // // // // // // // //